//+------------------------------------------------------------------+
//+------------------------------------------------------------------+//
//  A smooth RSI indicator (in purple by default)
//  and a faster RSI (in white by default).
// 
// 


#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 Magenta
#property indicator_color2 White
#property indicator_level1 80
#property indicator_level2 20
#property indicator_level3 50
#property indicator_maximum 100
#property indicator_minimum 0

//---- input parameters
extern int Len1=5; 
extern int Len2=5; 
extern int FastEMA=10;
extern int SlowEMA=40;

double rss[];
double rsifast[]; 
double rsi_value;

int init() {
  SetIndexStyle(0,DRAW_LINE);
  SetIndexBuffer(0,rss);
  IndicatorShortName("RSS("+Len2+")");

  SetIndexStyle(1,DRAW_LINE);
  SetIndexBuffer(1,rsifast); 
 
  return(0);
}

int deinit()
{
return(0);
}

int start()
{
  int counted_bars=IndicatorCounted(),limit,shift;

  if (counted_bars<0) return(-1);
  if (counted_bars>0) counted_bars--;
  limit=Bars-Len2-2;
 //  if(counted_bars>Len) limit=Bars-counted_bars-1;

  for (shift=limit;shift>=0;shift--) {
    rsifast[shift] = iRSI(NULL,0,Len2,(iMA(NULL,0,FastEMA,0,MODE_SMA,PRICE_CLOSE,shift)-iMA(NULL,0,SlowEMA,0,MODE_SMA,PRICE_CLOSE,shift)),shift); 
   }
   
  for (shift=limit;shift>=0;shift--) {
    rss[shift] = iMAOnArray(rsifast,limit,Len1,0,MODE_SMA,shift);    
  }  
return(0);
}

